# 帳票設計書 7-Crash Reporter

## 概要

本ドキュメントは、VS Codeのクラッシュレポート機能における帳票出力仕様を定義するものである。Crash Reporterは、アプリケーションクラッシュ時の情報を収集し、診断用のダンプファイルを生成・送信する機能である。

### 本帳票の処理概要

Crash Reporterは、ElectronのcrashReporter APIを使用してVS Codeのクラッシュ情報を収集・送信する機能である。

**業務上の目的・背景**：VS Codeの安定性向上のため、クラッシュ発生時の情報を開発チームに送信し、問題の特定と修正を支援する。ユーザーの同意に基づいてテレメトリデータとしてクラッシュ情報を収集する。

**帳票の利用シーン**：
- VS Codeがクラッシュした際に自動的にダンプファイルを生成
- AppCenter経由でクラッシュレポートを送信（有効時）
- ローカルディレクトリへのクラッシュダンプ保存（--crash-reporter-directory指定時）

**主要な出力内容**：
1. クラッシュダンプファイル（minidump形式）
2. プロダクト名
3. バージョン情報
4. クラッシュレポーターID（UUID）

**帳票の出力タイミング**：アプリケーションクラッシュ発生時に自動生成。

**帳票の利用者**：VS Code開発チーム（内部使用）

## 帳票種別

クラッシュダンプ / 診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | N/A | - | クラッシュ発生時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Minidump (.dmp) |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | システム生成（UUID等） |
| 出力方法 | Electron crashReporter API |
| 文字コード | バイナリ |

### 送信設定

| 項目 | 内容 |
|-----|------|
| Submit URL | AppCenter URL（プラットフォーム別） |
| 圧縮 | true |
| システムハンドラ無視 | true |

### 出力先

| 条件 | 出力先 |
|------|-------|
| --crash-reporter-directory指定時 | 指定ディレクトリ |
| AppCenter有効時 | AppCenterサーバー |
| デフォルト | app.getPath('crashDumps') |

## 帳票レイアウト

### レイアウト概要

クラッシュレポートはMinidump形式のバイナリデータとして出力される。以下はレポートに含まれるメタデータ：

### クラッシュレポートメタデータ

| No | 項目名 | 説明 | データ取得元 | 備考 |
|----|-------|------|-------------|------|
| 1 | companyName | 会社名 | product.crashReporter.companyName | デフォルト: 'Microsoft' |
| 2 | productName | 製品名 | product.crashReporter.productName | デフォルト: product.nameShort |
| 3 | submitURL | 送信先URL | 計算値 | プラットフォーム別AppCenter URL |
| 4 | uploadToServer | サーバー送信フラグ | 計算値 | 条件に基づく |
| 5 | compress | 圧縮フラグ | 固定 | true |
| 6 | ignoreSystemCrashHandler | システムハンドラ無視 | 固定 | true |

### AppCenter URL（プラットフォーム別）

| プラットフォーム | アーキテクチャ | 設定キー |
|----------------|---------------|---------|
| Windows | x64 | appCenter['win32-x64'] |
| Windows | arm64 | appCenter['win32-arm64'] |
| macOS Universal | - | appCenter['darwin-universal'] |
| macOS | x64 | appCenter['darwin'] |
| macOS | arm64 | appCenter['darwin-arm64'] |
| Linux | x64 | appCenter['linux-x64'] |

### Submit URL パラメータ

| パラメータ | 説明 | 取得元 |
|-----------|------|-------|
| uid | ユーザーID | crashReporterId (UUID) |
| iid | インストールID | crashReporterId (UUID) |
| sid | セッションID | crashReporterId (UUID) |

## 出力条件

### 有効化条件

| 条件名 | 説明 |
|-------|------|
| --crash-reporter-directory | ローカル保存モード有効 |
| enable-crash-reporter (argv.json) | クラッシュレポート有効 |
| !--disable-crash-reporter | 無効化されていない |
| !process.env.VSCODE_DEV | 開発モードでない |
| crash-reporter-id存在 | UUIDが設定されている |

### UUID検証

| 条件 | パターン |
|------|---------|
| UUIDフォーマット | `/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i` |

### 改ページ条件

N/A（バイナリファイル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| argv.json | 設定読み込み | ファイル読み込み |
| product.json | 製品情報 | bootstrap-meta.js |

### データ取得元

#### argv.json

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| enable-crash-reporter | 有効化フラグ | fs.readFileSync + JSON parse | boolean |
| crash-reporter-id | UUID | fs.readFileSync + JSON parse | string (UUID) |

#### product.json

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| crashReporter.productName | productName | import | 製品名 |
| crashReporter.companyName | companyName | import | 会社名 |
| appCenter | Submit URL | import | プラットフォーム別URL |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| uploadToServer | !VSCODE_DEV && submitURL && !crashReporterDirectory | - | Boolean |
| submitURL | baseUrl.concat('&uid=', id, '&iid=', id, '&sid=', id) | - | URL構築 |

## 処理フロー

### クラッシュレポート設定フロー

```mermaid
flowchart TD
    A[main.ts起動] --> B{--crash-reporter-directory?}
    B -->|Yes| C[ローカル保存モード]
    B -->|No| D{enable-crash-reporter && !disable?}
    C --> E[app.setPath crashDumps]
    D -->|No| F[クラッシュレポート無効]
    D -->|Yes| G{crash-reporter-id有効?}
    G -->|No| F
    G -->|Yes| H[Submit URL構築]
    H --> I[crashReporter.start]
    E --> I
    I --> J[クラッシュ監視開始]
```

### クラッシュ発生時フロー

```mermaid
flowchart TD
    A[クラッシュ発生] --> B[Electron crashReporter検知]
    B --> C[Minidump生成]
    C --> D{uploadToServer?}
    D -->|Yes| E[AppCenterに送信]
    D -->|No| F[ローカルに保存]
    E --> G[完了]
    F --> G
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パス不正 | --crash-reporter-directoryが相対パス | "The path '...' must be absolute." | 絶対パスを指定 |
| ディレクトリ作成失敗 | 指定パスが作成不可 | "does not seem to exist or cannot be created" | パス確認 |
| UUID不正 | crash-reporter-idがUUID形式でない | (無視してレポート無効) | argv.json確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | クラッシュ1件につき1ダンプ |
| 目標出力時間 | クラッシュ時即時（同期処理） |
| 同時出力数上限 | 1件/クラッシュ |

## セキュリティ考慮事項

- クラッシュダンプにはメモリ内容が含まれる可能性があり、機密情報漏洩リスク
- UUID (crash-reporter-id)でユーザーを識別可能
- AppCenterへの送信はユーザー同意が前提（argv.jsonで設定）
- VSCODE_DEV環境ではサーバー送信無効

## 備考

- クラッシュレポート設定はapp 'ready'イベント前に完了する必要あり
- ExtensionHost等の子プロセスにもcrash-reporter-idが伝達される
- ポータブルモード時はログパスがポータブルディレクトリ内に設定される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定の読み込みを理解する

クラッシュレポート設定の読み込みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.ts | `src/main.ts` | configureCrashReporter()呼び出し箇所 (行82-84) |
| 1-2 | main.ts | `src/main.ts` | readArgvConfigSync() (行383-404) |

**読解のコツ**: argv.jsonからenable-crash-reporterとcrash-reporter-idを読み取る。

#### Step 2: クラッシュレポーター設定を理解する

実際の設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.ts | `src/main.ts` | configureCrashReporter() (行452-542) |

**主要処理フロー**:
- **行452-476**: --crash-reporter-directory処理
- **行478-528**: AppCenter URL構築とパラメータ付与
- **行530-541**: crashReporter.start()呼び出し

#### Step 3: 製品設定を理解する

製品固有の設定値を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | product.json | `product.json` | appCenter, crashReporter設定 |
| 3-2 | bootstrap-meta.js | `src/bootstrap-meta.js` | product読み込み |

### プログラム呼び出し階層図

```
main.ts (起動)
    │
    ├─ parseCLIArgs() // コマンドライン解析
    │
    ├─ configureCommandlineSwitchesSync()
    │      │
    │      └─ readArgvConfigSync() // argv.json読み込み
    │
    └─ configureCrashReporter()
           │
           ├─ args['crash-reporter-directory']チェック
           │      │
           │      ├─ path.normalize()
           │      ├─ path.isAbsolute()チェック
           │      └─ app.setPath('crashDumps', dir)
           │
           ├─ appCenter URL構築
           │      │
           │      ├─ プラットフォーム判定
           │      ├─ アーキテクチャ判定
           │      └─ UUID付与
           │
           └─ crashReporter.start({
                  companyName,
                  productName,
                  submitURL,
                  uploadToServer,
                  compress: true,
                  ignoreSystemCrashHandler: true
              })
```

### データフロー図

```
[入力]                    [処理]                           [出力]

argv.json            ┌─────────────────────┐
 - enable-crash     │                     │
   -reporter ───────▶│ configureCrash      │
 - crash-reporter   │   Reporter()        │
   -id ─────────────▶│                     │
                     │                     │
product.json        │ - URL構築           │──────▶ crashReporter.start()
 - appCenter ───────▶│ - パラメータ設定    │
 - crashReporter ───▶│                     │
                     └─────────────────────┘

[クラッシュ発生時]

クラッシュイベント   ┌─────────────────────┐
                     │                     │
    ────────────────▶│ Electron           │──────▶ .dmp ファイル
                     │ crashReporter      │        (ローカル or AppCenter)
                     │                     │
                     └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.ts | `src/main.ts` | ソース | メインエントリーポイント |
| bootstrap-meta.js | `src/bootstrap-meta.js` | ソース | 製品メタデータ |
| product.json | `product.json` | 設定 | 製品設定 |
| argv.json | `{userData}/argv.json` | 設定 | ユーザー設定 |
